<?php
session_start();
include 'koneksi.php';

if (!isset($_SESSION['admin']) || !isset($_GET['id'])) { die("Akses Ditolak"); }

$id_siswa = $_GET['id'];

// 1. AMBIL DATA SISWA
$q_siswa = mysqli_query($koneksi, "SELECT * FROM siswa WHERE id='$id_siswa'");
$d_siswa = mysqli_fetch_array($q_siswa);

// 2. HITUNG ABSENSI (Dari tabel absensi)
function hitung_absen($koneksi, $id, $ket){
    $q = mysqli_query($koneksi, "SELECT COUNT(*) as jum FROM absensi WHERE id_siswa='$id' AND keterangan='$ket'");
    $d = mysqli_fetch_assoc($q);
    return $d['jum'];
}
$sakit = hitung_absen($koneksi, $id_siswa, 'S');
$izin  = hitung_absen($koneksi, $id_siswa, 'I');
$alpha = hitung_absen($koneksi, $id_siswa, 'A');
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Rapor - <?= $d_siswa['nama'] ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 14px; padding: 40px; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 3px double black; padding-bottom: 10px; }
        .header h2, .header h4 { margin: 0; }
        .biodata { width: 100%; margin-bottom: 20px; }
        .biodata td { padding: 5px; }
        .table-nilai { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .table-nilai th, .table-nilai td { border: 1px solid black; padding: 8px; text-align: center; }
        .table-nilai th { background-color: #f0f0f0; }
        .text-left { text-align: left !important; }
        .ttd { width: 100%; margin-top: 50px; text-align: center; }
        @media print { .no-print { display: none; } }
    </style>
</head>
<body>

    <!-- Tombol Print -->
    <button onclick="window.print()" class="no-print" style="padding: 10px 20px; background: blue; color: white; border: none; cursor: pointer; margin-bottom: 20px;">🖨️ Cetak Halaman</button>

    <!-- KOP RAPOR -->
    <div class="header">
        <h2>SMA 1 CONTOH</h2>
        <h4>LAPORAN HASIL BELAJAR SISWA</h4>
        <small>Jl. Pendidikan No. 123, Kota Belajar, Indonesia</small>
    </div>

    <!-- BIODATA -->
    <table class="biodata">
        <tr>
            <td width="150">Nama Siswa</td>
            <td width="10">:</td>
            <td><b><?= $d_siswa['nama'] ?></b></td>
            <td width="100">Kelas</td>
            <td width="10">:</td>
            <td><?= $d_siswa['kelas'] ?></td>
        </tr>
        <tr>
            <td>Nomor Induk</td>
            <td>:</td>
            <td><?= $d_siswa['nis'] ?></td>
            <td>Semester</td>
            <td>:</td>
            <td>Ganjil / Genap</td>
        </tr>
    </table>

    <!-- TABEL NILAI -->
    <h4 style="margin-bottom: 10px;">A. NILAI AKADEMIK</h4>
    <table class="table-nilai">
        <thead>
            <tr>
                <th width="50">No</th>
                <th>Mata Pelajaran</th>
                <th>Nilai (0-100)</th>
                <th>Predikat</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $no = 1;
            $q_nilai = mysqli_query($koneksi, "SELECT * FROM nilai WHERE id_siswa='$id_siswa'");
            
            if(mysqli_num_rows($q_nilai) > 0) {
                while($n = mysqli_fetch_array($q_nilai)){
                    // Hitung Rata-rata UH+UTS+UAS
                    $nilai_akhir = round(($n['nilai_uh'] + $n['nilai_uts'] + $n['nilai_uas']) / 3);
                    
                    // Tentukan Predikat
                    if($nilai_akhir >= 90) { $predikat = "A"; $ket = "Sangat Baik"; }
                    elseif($nilai_akhir >= 80) { $predikat = "B"; $ket = "Baik"; }
                    elseif($nilai_akhir >= 70) { $predikat = "C"; $ket = "Cukup"; }
                    else { $predikat = "D"; $ket = "Kurang"; }
            ?>
            <tr>
                <td><?= $no++ ?></td>
                <td class="text-left"><?= $n['mapel'] ?></td>
                <td><b><?= $nilai_akhir ?></b></td>
                <td><?= $predikat ?></td>
                <td class="text-left"><?= $ket ?></td>
            </tr>
            <?php 
                } 
            } else {
                echo "<tr><td colspan='5'>Belum ada data nilai.</td></tr>";
            }
            ?>
        </tbody>
    </table>

    <!-- TABEL ABSENSI -->
    <h4 style="margin-bottom: 10px;">B. KETIDAKHADIRAN</h4>
    <table class="table-nilai" style="width: 50%;">
        <tr>
            <td class="text-left" width="60%">Sakit</td>
            <td><?= $sakit ?> Hari</td>
        </tr>
        <tr>
            <td class="text-left">Izin</td>
            <td><?= $izin ?> Hari</td>
        </tr>
        <tr>
            <td class="text-left">Tanpa Keterangan</td>
            <td><?= $alpha ?> Hari</td>
        </tr>
    </table>

    <!-- TANDA TANGAN -->
    <table class="ttd">
        <tr>
            <td width="50%">
                Mengetahui,<br>Orang Tua Wali
                <br><br><br><br>
                ( ........................... )
            </td>
            <td width="50%">
                Kota Belajar, <?= date('d F Y') ?><br>Wali Kelas
                <br><br><br><br>
                ( <b>Budi Santoso, S.Pd</b> )
            </td>
        </tr>
    </table>

</body>
</html>